/* CUSTOM ANCHOR LINKS SCRIPT FOR BOOTSTRAP 5.3 OFFCANVAS NAVIGATION: */

/*
  Close offcanvas menu after clicking ANCHOR links

  This was necessary because Bootstrap doesn't close the offcanvas menu for anchor  links on a single page app.

  1. I used ChatGPT to help me figure out which functions the default Bootstrap 'close' button calls and how to get them from the global scope in order to use in this file.

  2. I then added the closeOffcanvas() functionality to each .nav-link menu item in the .offcanvas menu.

  This is far more complete than my initial version that removed the 'show' class. That initial version was not clean and required 2 clicks of .toggler to re-open the menu.

 */

// 1.
// Function to open the offcanvas menu
function openOffcanvas() {
  bootstrap.Offcanvas.getInstance(document.querySelector('.offcanvas')).show();
}

// Function to close the offcanvas menu
function closeOffcanvas() {
  bootstrap.Offcanvas.getInstance(document.querySelector('.offcanvas')).hide();
}

// Add a click event listener to the toggler button
document.querySelector('.navbar-toggler').addEventListener('click', function() {
  // Check if the offcanvas menu is currently hidden
  const offcanvas = document.querySelector('.offcanvas');
  const isOpen = offcanvas.classList.contains('show');
  
  // Toggle the offcanvas menu based on its current state
  if (isOpen) {
    closeOffcanvas(); // Close the offcanvas menu
  } else {
    openOffcanvas(); // Open the offcanvas menu
  }
});

// 2.
// Add a click event listener to all .nav-link elements inside the offcanvas menu
const offcanvasLinks = document.querySelectorAll('.offcanvas .nav-link');
offcanvasLinks.forEach(function(link) {
  link.addEventListener('click', function() {
    closeOffcanvas(); // Close the offcanvas menu when any .nav-link is clicked
  });
});


/*
    Add .current to any .nav-link when clicked and remove from others - this allows me to underline the currently viewed section in the nav menu
 */
document.addEventListener("DOMContentLoaded", function() {
    // Get all elements with the class '.nav-link'
    var navLinks = document.querySelectorAll('.nav-link');
    
    // Add click event listener to each element
    navLinks.forEach(function(navLink) {
        navLink.addEventListener('click', function() {
            // Remove the 'current' class from all elements with the class '.nav-link'
            navLinks.forEach(function(link) {
                link.classList.remove('current');
            });
            
            // Add the 'current' class to the clicked element
            this.classList.add('current');
        });
    });
});

